<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\AdminContoller;
use App\Http\Controllers\Auth\LoginController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

Auth::routes();

// PAGES //

Route::get('/', [PageController::class, 'index'])->name('home');
Route::get('/finddriver', [PageController::class, 'finddriver'])->name('finddriver');
Route::get('/downloadapp', [PageController::class, 'downloadapp'])->name('downloadapp');
Route::get('/driverinfo', [PageController::class, 'driverinfo'])->name('driverinfo');
Route::get('/signupcustmer', [PageController::class, 'signupcustmer'])->name('signupcustmer');
Route::get('/signin', [PageController::class, 'signin'])->name('signin');
Route::get('/driversignin', [PageController::class, 'driversignin'])->name('driversignin');

Route::get('/list', [PageController::class, 'list'])->name('list');


//Admin
Route::middleware(['is_admin', 'auth'])->group(function () {
    Route::get('/admin/home', [AdminContoller::class, 'dashboard'])->name('admin.home');
    Route::get('/adminCustomer', [AdminContoller::class, 'adminCustomer'])->name('admin.customer');
    
    
});



//USER//

Route::middleware(['is_user', 'auth'])->group(function () {
    
    
    
    
});


//driver

Route::middleware(['is_driver', 'auth'])->group(function () {
    
Route::get('/steps', [PageController::class, 'steps'])->name('steps');
Route::get('/driverportal', [PageController::class, 'driverportal'])->name('driverportal');




});


Route::post('/logout', [App\Http\Controllers\Auth\LoginController::class, 'logout'])->name('logout');
