@extends('frontend.layout.main')

@section('inner')
    <section>
        <div class="container-fluid px-4">
            <div class="list">
                <div class="row mt-4">
                    <div class="col-md-6">
                        <div class="headings d-flex justify-content-between">
                            <h2>CUSTOMER WAITLIST</h2>
                            <a href="">Join As Customer</a>
                        </div>
                        <div class="bdr my-2"></div>
                        <div class="listable pt-4">
                            <table>
                                <thead>
                                    <tr>
                                        <th>No.</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($user as $users)
                                        <tr class="{{ Auth::check() && Auth::user()->id == $users->id ? ' text-#FF0000' : ''}}">
                                            <td>{{ $users->id }}</td>
                                            <td>{{ $users->fname }}</td>
                                            <td>{{ $users->email }}</td>
                                            <td>{{ $users->phone }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>
                    </div>
                    <div class="col-md-6 ">
                        <div class="headings d-flex justify-content-between">
                            <h2>DRIVER WAITLIST</h2>
                            <a href="">Join As Driver</a>
                        </div>
                        <div class="bdr my-2"></div>

                        <div class="listable pt-4">
                            <table>
                                <tr>
                                    <th>No.</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                </tr>
                                @foreach ($driver as $drivers)
                                    <tr
                                        class="{{ Auth::check() && Auth::user()->id == $drivers->id ? ' text-#FF0000' : '' }}">
                                        <td>{{ $drivers->id }}</td>
                                        <td>{{ $drivers->fname }}</td>
                                        <td>{{ $drivers->email }}</td>
                                        <td>{{ $drivers->phone }}</td>
                                    </tr>
                                @endforeach
                                {{-- <tr>
                                    <td>02</td>
                                    <td>Ronald Perera</td>
                                    <td>ronald7845@yahoo.ca</td>
                                    <td>416 274 9387</td>
                                </tr>
                                <tr>
                                    <td>03</td>
                                    <td>Vandya Chaudhary</td>
                                    <td>vandya_chaudhary@gmail.com</td>
                                    <td>416 274 9387</td>
                                </tr>
                                <tr>
                                    <td>04</td>
                                    <td>Kiran Nallamothu</td>
                                    <td>KiranN@rogers.com</td>
                                    <td>416 274 9387</td>
                                </tr>
                                <tr>
                                    <td>05</td>
                                    <td>Scott Black</td>
                                    <td>scott.black@gmail.com</td>
                                    <td>416 274 9387</td>
                                </tr>
                                <tr>
                                    <td>06</td>
                                    <td>Pooja Mowchun</td>
                                    <td>poojam@rogers.com</td>
                                    <td>416 274 9387</td>
                                </tr>
                                <tr>
                                    <td>07</td>
                                    <td>Ryan Pawson</td>
                                    <td>ryanpawson@bell.ca</td>
                                    <td>416 274 9387</td>
                                </tr>
                                <tr>
                                    <td>08</td>
                                    <td>Grace Handa</td>
                                    <td>Ghanda@gmail.com</td>
                                    <td>416 274 9387</td>
                                </tr>
                                <tr>
                                    <td>09</td>
                                    <td>Tushar Elegbede</td>
                                    <td>tushar847@rogers.com</td>
                                    <td>416 274 9387</td>
                                </tr> --}}
                            </table>
                        </div>
                    </div>
                </div>
                <div class="bdr my-5"></div>
            </div>
        </div>

    </section>
@endsection
