@extends('frontend.layout.main')

@section('inner')

  <section>
    <div class="container-fluid px-4">
      <div class="driversignin">
       
        <div class="row my-3 justify-content-between">
          <div class="col-md-3">
            <div class="headings mt-4">
              <h2>DRIVER SIGN IN </h2>

            </div>
            <form class="infoForm2" method="POST" action="{{ route('login') }}">
              @csrf

              <div class="row mb-3">
                  {{-- <label for="email" class="col-md-4 col-form-label text-md-end">{{ __('Email Address') }}</label> --}}

                  <div class="col-md-12">
                      <input id="email" type="email" placeholder="Email"
                          class="form-control @error('email') is-invalid @enderror" name="email"
                          value="{{ old('email') }}" required autocomplete="email" autofocus>

                      @error('email')
                          <span class="invalid-feedback" role="alert">
                              <strong>{{ $message }}</strong>
                          </span>
                      @enderror
                  </div>
              </div>

              <div class="row mb-3">
                  {{-- <label for="password" class="col-md-4 col-form-label text-md-end">{{ __('Password') }}</label> --}}

                  <div class="col-md-12">
                      <input id="password" type="password" placeholder="Password"
                          class="form-control @error('password') is-invalid @enderror" name="password"
                          required autocomplete="current-password">

                      @error('password')
                          <span class="invalid-feedback" role="alert">
                              <strong>{{ $message }}</strong>
                          </span>
                      @enderror
                  </div>
              </div>

              <div class="row mb-3 align-items-end">
                  <div class="col-md-6">
                      <div class="form-check">
                          <input class="form-check-input me-2 w-20" type="checkbox" name="remember" id="remember"
                              {{ old('remember') ? 'checked' : '' }}>

                          <label class="form-check-label d-flex" for="remember">
                              {{ __('Remember Me') }}

                          </label>
                      </div>
                  </div>
              </div>

              <div class="row mb-0">
                  <div class="col-md-12">
                      <button type="submit" class="btn btn-primary">
                          {{ __('Login') }}
                      </button>

                      @if (Route::has('password.request'))
                          <a class="btn btn-link" href="{{ route('password.request') }}">
                              {{ __('Forgot Your Password?') }}
                          </a>
                      @endif
                      <a href="{{ route('register') }}">{{ __('Register') }}</a>
                  </div>
              </div>
          </form>
          </div>
          <div class="col-md-6">
            <img src="{{asset('/frontend/assets/image/BroncoJPG.png')}}" width="100%"  class="mt-5"alt="img">
            
          </div>

          <div class="headPage">

            <div class="bdr my-5"></div>
          </div>
        </div>
      </div>
    </div>
  </section>



  @endsection