<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = '/list';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        $rules = [
            'fname' => ['required', 'string', 'max:255'],
            'lname' => ['required', 'string', 'max:255'],
            'email' => ['required'],
            'phone' => ['required'],
            'country' => ['required'],
            'state' => ['required'],
            'city' => ['required'],
            'address' => ['required'],
            'postalcode' => ['required'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ];

        // Conditional rules based on form submission
        if (isset($data['is_user'])) {
            $rules['is_user'] = ['nullable'];
        }

        if (isset($data['is_driver'])) {
            $rules['is_driver'] = ['nullable'];
        }

        return Validator::make($data, $rules);
    }


    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {
        $userData = [
            'fname' => $data['fname'],
            'lname' => $data['lname'],
            'email' => $data['email'],
            'phone' => $data['phone'],
            'country' => $data['country'],
            'state' => $data['state'],
            'city' => $data['city'],
            'address' => $data['address'],
            'postalcode' => $data['postalcode'],
            'password' => Hash::make($data['password']),
        ];

        // Check if is_user or is_driver is set and add to $userData accordingly
        if (isset($data['is_user'])) {
            $userData['is_user'] = $data['is_user'];
        }

        if (isset($data['is_driver'])) {
            $userData['is_driver'] = $data['is_driver'];
        }

        return User::create($userData);
    }
    protected function redirectTo()
    {
        return route('list');
    }
}
